<?php

/**
 * @file
 * Default simple view template to all the fields as a row.
 *
 * - $view: The view in use.
 * - $fields: an array of $field objects. Each one contains:
 *   - $field->content: The output of the field.
 *   - $field->raw: The raw data for the field, if it exists. This is NOT output safe.
 *   - $field->class: The safe class id to use.
 *   - $field->handler: The Views field handler object controlling this field. Do not use
 *     var_export to dump this object, as it can't handle the recursion.
 *   - $field->inline: Whether or not the field should be inline.
 *   - $field->inline_html: either div or span based on the above flag.
 *   - $field->wrapper_prefix: A complete wrapper containing the inline_html to use.
 *   - $field->wrapper_suffix: The closing tag for the wrapper.
 *   - $field->separator: an optional separator that may appear before a field.
 *   - $field->label: The wrap label text to use.
 *   - $field->label_html: The full HTML of the label to use including
 *     configured element type.
 * - $row: The raw result object from the query, with all data it fetched.
 *
 * @ingroup views_templates
 */

global $base_url;
$author = user_load($fields['uid']->content);
if (user_is_logged_in()) {
  $author_name = '<a href="'.$base_url.'/user/'.$author->uid.'">'. ucfirst($author->name).'</a>';
}else{
  $author_name = '<a>'.ucfirst($author->name).'</a>';
}

?>

<div class="post">
    <?php print $fields['field_media']->content;?>

    <div class="post-text">
      <h2 class="post-title"><a href="<?php print $fields['path']->content; ?>"><?php print $row->node_title?></a></h2>
      <div class="post-meta">
        <span>By</span> <?php print $author_name?>  
        <?php print date('d F Y',$row->node_created)?> 
        <?php if( $blog_4col != 'col-4'):?>
          <a href="#" class="comments"><?php print $row->node_comment_statistics_comment_count;?> Comments</a>
        <?php endif;?>
        
      </div>
      <div class="post-excerpt">
        <?php print $fields['body']->content?>
      </div>
      <div class="post-more">
        <a href="<?php print $fields['path']->content; ?>" class="btn btn-dark btn-rounded hover-effect">Read more</a>
      </div>
    </div>
</div>
